<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('case_name', 'age', 'blood_type_id', 'amount', 'hospital_name', 'hospital_location', 'city_id', 'number', 'notes');

    public function client()
    {
        return $this->belongsTo('App\Http\Models\Client');
    }

    public function blood_type()
    {
        return $this->hasOne('App\Http\Models\BloodType');
    }

    public function governorate()
    {
        return $this->belongsTo('App\Http\Models\Governorate');
    }

    public function notifications()
    {
        return $this->hasMany('App\Http\Models\Notification');
    }

}